<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Notes extends Model 
{

    protected $table = 'notes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('violation_code', 'longitude', 'latitude', 'comment', 'direction_id', 'cause', 'status', 'redirect');

    public function type()
    {
        return $this->belongsTo('Type');
    }

    public function priority()
    {
        return $this->belongsTo('Priority');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function area()
    {
        return $this->belongsTo('Area');
    }

    public function dirction()
    {
        return $this->belongsTo('App\Models\Direction');
    }

}